/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.registry.item;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.redpxnda.nucleus.util.PlayerUtil;
import com.redpxnda.respawnobelisks.config.TeleportConfig;
import com.redpxnda.respawnobelisks.data.listener.ObeliskInteraction;
import com.redpxnda.respawnobelisks.data.saved.RuneCircles;
import com.redpxnda.respawnobelisks.registry.ModRegistries;
import com.redpxnda.respawnobelisks.registry.block.RespawnObeliskBlock;
import com.redpxnda.respawnobelisks.registry.block.entity.RespawnObeliskBlockEntity;
import com.redpxnda.respawnobelisks.util.ClientUtils;
import com.redpxnda.respawnobelisks.util.CoreUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BoundCompassItem
extends CompassItem {
    private static final Logger LOGGER = LogUtils.getLogger();

    public BoundCompassItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        if (!TeleportConfig.enableTeleportation) {
            return InteractionResult.FAIL;
        }
        if (useOnContext.m_43723_() == null) {
            return super.m_6225_(useOnContext);
        }
        Player player = useOnContext.m_43723_();
        BlockPos blockPos = useOnContext.m_8083_();
        Level level = useOnContext.m_43725_();
        if (level.m_8055_(blockPos).m_60713_(Blocks.f_50729_)) {
            level.m_5594_(null, blockPos, SoundEvents.f_12107_, SoundSource.PLAYERS, 1.0f, 1.0f);
            ItemStack itemStack = useOnContext.m_43722_();
            if (!player.m_150110_().f_35937_ && itemStack.m_41613_() == 1) {
                this.addLodestoneTags((ResourceKey<Level>)level.m_46472_(), blockPos, itemStack.m_41784_());
            } else {
                ItemStack itemStack2 = new ItemStack((ItemLike)ModRegistries.BOUND_COMPASS.get(), 1);
                CompoundTag compoundTag = itemStack.m_41782_() ? itemStack.m_41783_().m_6426_() : new CompoundTag();
                itemStack2.m_41751_(compoundTag);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                this.addLodestoneTags((ResourceKey<Level>)level.m_46472_(), blockPos, compoundTag);
                if (!player.m_150109_().m_36054_(itemStack2)) {
                    player.m_36176_(itemStack2, false);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (useOnContext.m_43724_().equals((Object)InteractionHand.MAIN_HAND) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level instanceof ServerLevel) {
                Block block;
                ServerLevel serverLevel = (ServerLevel)level;
                if (!TeleportConfig.allowCursedTeleportation && player.m_21023_((MobEffect)ModRegistries.IMMORTALITY_CURSE.get())) {
                    serverPlayer.m_240418_((Component)Component.m_237115_((String)"text.respawnobelisks.wormhole_cursed"), true);
                    return InteractionResult.FAIL;
                }
                GlobalPos pos = BoundCompassItem.m_220021_((CompoundTag)player.m_21205_().m_41784_());
                if (pos != null && (block = level.m_8055_(pos.m_122646_().m_7494_()).m_60734_()) instanceof RespawnObeliskBlock) {
                    RespawnObeliskBlockEntity blockEntity;
                    RespawnObeliskBlock block2 = (RespawnObeliskBlock)block;
                    block = level.m_7702_(pos.m_122646_().m_7494_());
                    if (block instanceof RespawnObeliskBlockEntity && (blockEntity = (RespawnObeliskBlockEntity)block).getCharge(player) >= TeleportConfig.minimumTpCharge) {
                        if (!CoreUtils.hasInteraction(blockEntity.getCoreInstance(), ObeliskInteraction.TELEPORT)) {
                            serverPlayer.m_240418_((Component)Component.m_237115_((String)"text.respawnobelisks.wormhole_invalid"), true);
                            return InteractionResult.FAIL;
                        }
                        if (PlayerUtil.getTotalXp((Player)player) < TeleportConfig.xpCost || player.f_36078_ < TeleportConfig.levelCost) {
                            serverPlayer.m_240418_((Component)Component.m_237115_((String)"text.respawnobelisks.wormhole_failed_requirements"), true);
                            return InteractionResult.FAIL;
                        }
                        BlockState state = level.m_8055_(pos.m_122646_().m_7494_());
                        Optional<Vec3> obeliskLoc = block2.getRespawnLocation(true, false, false, state, pos.m_122646_().m_7494_(), serverLevel, serverPlayer);
                        obeliskLoc.ifPresent(vec3 -> {
                            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 130, 0, true, false));
                            RuneCircles.getCache(serverLevel).create(serverPlayer, serverPlayer.m_21205_(), pos.m_122646_().m_7494_(), new BlockPos(vec3), serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_());
                        });
                        return InteractionResult.SUCCESS;
                    }
                }
                serverPlayer.m_240418_((Component)Component.m_237115_((String)"text.respawnobelisks.wormhole_invalid"), true);
                return InteractionResult.FAIL;
            }
        }
        return super.m_6225_(useOnContext);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        if (level != null && level.f_46443_) {
            ClientUtils.addCompassTooltipLines(itemStack, level, list, tooltipFlag);
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return ClientUtils.isBoundCompassBarVisible(stack);
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)0.5f, (float)0.66f, (float)1.0f);
    }

    public int m_142158_(ItemStack itemStack) {
        return ClientUtils.getBoundCompassBarWidth(itemStack);
    }

    public String m_5671_(ItemStack itemStack) {
        return BoundCompassItem.m_40736_((ItemStack)itemStack) ? "item.respawnobelisks.bound_bound_compass" : super.m_5671_(itemStack);
    }

    private void addLodestoneTags(ResourceKey<Level> resourceKey, BlockPos blockPos, CompoundTag compoundTag) {
        compoundTag.m_128365_("LodestonePos", (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, resourceKey).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.m_128365_("LodestoneDimension", tag));
        compoundTag.m_128379_("LodestoneTracked", true);
    }
}

